# Metalness Loader by 3deoskill
# Thomas Bösl
# Am Stadtpark 22
# 09120 Chemnitz
# www.3deoskill.com
# info@3deoskill.com
# Simplifies the process to load textures for the Metalness/Roughness workflow
# Support 2 methods: Using Color Chanel (faster Rendering) or physical
# Supports Semi-Auto-Loading the textures in order by opening File Dialog for each (Title is Texture)
# Or manual loading
# Only Standard and Physical Renderer maybe Redshift is coming soon

import c4d
from c4d import gui, Xnormalizer
import os

PY_HEADLINE = 1
PY_SEMI_LOAD = 2
PY_BUMPASNORMAL = 3
PY_PHYSICAL_MODE = 4
PY_CREATE = 5
PY_GROUP = 10
PY_GROUP_CHECKBOX = 11


NAME_LIST = ["Albedo",
             "AO",
             "Emission",
             "Transparency",
             "Metalness",
             "Roughness",
             "Bump",
             "Normal",
             "Alpha",
             "Displacement"]

class LoadGui(c4d.gui.GeDialog):

    def __init__(self):
        super().__init__()
        self.textures = [None, None, None, None, None, None, None, None, None, None]
        self.dicto = {}

    def CreateLayout(self, loaded=False):

        if not loaded:
            self.SetTitle("Metalness Workflow Loader")
            self.AddStaticText(PY_HEADLINE, c4d.BFH_SCALEFIT, inith=32, name="Select the maps you want to import. Press -Semi Auto Load-.\n"
                                                         "It opens several file dialogs one after the other. The title of the dialog indicates which map is currently being loaded.",
                                  borderstyle=c4d.BORDER_OUT | c4d.BORDER_WITH_TITLE_MONO |c4d.BORDER_ROUND)


            self.AddButton(PY_SEMI_LOAD, flags=c4d.BFH_SCALEFIT, inith=20, name="Semi Auto Load")

            self.GroupBegin(PY_GROUP_CHECKBOX, flags=c4d.BFH_SCALEFIT, cols=2, rows=1)
            self.AddCheckbox(PY_PHYSICAL_MODE, flags=c4d.BFH_LEFT, initw=128, inith=20, name="Physical")
            self.AddCheckbox(PY_BUMPASNORMAL, flags=c4d.BFH_LEFT, initw=128, inith=20, name="Bump as Normal")
            self.GroupEnd()

            self.GroupBegin(PY_GROUP, flags=c4d.BFH_SCALEFIT, cols = 4, rows=10)
            count = 0
            for i in range(100, 1100, 100):
                self.AddCheckbox(i + 2, flags=c4d.BFH_RIGHT, initw=32, inith=20, name="")

                self.AddStaticText(i + 1, flags=c4d.BFH_LEFT, initw=130, inith=16, name=NAME_LIST[count])

                self.AddEditText(i + 3, flags=c4d.BFH_SCALEFIT, initw=200, editflags=1)

                self.AddButton(i + 4, flags=c4d.BFH_RIGHT, name="Load")
                count += 1

            self.GroupEnd()
            self.AddButton(PY_CREATE, flags=c4d.BFH_SCALEFIT, inith=20, name="Create Material")

        return True

    def Command(self, id, msg):
        id_list = [104, 204, 304, 404, 504, 604, 704, 804, 904, 1004]
        if id in id_list:
            file = os.path.normpath(c4d.storage.LoadDialog(type=c4d.FILESELECTTYPE_IMAGES,
                                                           title="Load",
                                                           flags=c4d.FILESELECT_LOAD))
            self.SetString(id - 4 + 3, file)
            index = id_list.index(id)
            self.textures[index] = file

        if id == PY_SEMI_LOAD:

            count = 0
            liste = []
            for i in range(100, 1100, 100):
                if self.GetBool(i + 2):
                    string = NAME_LIST[count]
                    liste.append(string)
                    count += 1
                else:
                    liste.append(None)
            for i in range(len(liste)):
                if liste[i] is not None:
                    self.textures[i] = (os.path.normpath(c4d.storage.LoadDialog(type=c4d.FILESELECTTYPE_IMAGES,
                                                                                title=f" . . . . . . . . . . . . . . . . . . . . . . . . . Load {NAME_LIST[i]} Map . . . . . . . . . . . . . . . .",
                                                                                flags=c4d.FILESELECT_LOAD)))

            count = 0
            for index in range(100, 1100, 100):
                if self.textures[count] is not None:
                    self.SetString(index + 3, self.textures[count])
                count += 1


        elif id == PY_CREATE:
            count = 0
            for index in range(100, 1100, 100):
                check = self.GetBool(index + 2)
                name = NAME_LIST[count]
                path = self.GetString(index + 3)
                self.dicto[name] = {"on": check, "path": path}
                count += 1
            self.dicto["bump2normal"] = self.GetBool(PY_BUMPASNORMAL)
            self.dicto["physical"] = self.GetBool(PY_PHYSICAL_MODE)

            is_in = False
            for key in self.dicto:
                if key not in ["bump2normal", "physical"]:
                    if self.dicto[key]["path"]:
                        is_in = True
            if not is_in:
                c4d.gui.MessageDialog("You have to load at least 1 Texture to create a material", 0)
            else:
                self.Close()

        return True

    def InitValues(self):
        self.SetBool(PY_BUMPASNORMAL, False)
        self.SetBool(PY_PHYSICAL_MODE, False)
        count = 1
        liste = [1, 2, 5, 6, 8]
        for i in range(100, 1100, 100):
            self.SetString(i + 3, "")
            self.SetLong(i + 1, count)
            if count in liste:
                self.SetBool(i + 2, True)
            else:
                self.SetBool(i + 2, False)
            count += 1

        return True

# Main function
def main():
    dialog = LoadGui()
    dialog.Open(dlgtype=c4d.DLG_TYPE_MODAL_RESIZEABLE, xpos=-2, ypos=-2, defaultw=400, defaulth=600)
    data = dialog.dicto

    is_in = False
    for key in data:
        if key not in ["bump2normal", "physical"]:
            if data[key]["on"] and data[key]["path"]:
                is_in = True
    if not is_in:
        return

    # the active material
    path = os.path.join(os.path.split(__file__)[0], "metalness_ref.c4d")

    # mat = doc.GetActiveMaterial()
    temp = c4d.documents.LoadDocument(path, c4d.SCENEFILTER_MATERIALS)
    mat = temp.GetFirstMaterial()
    doc.InsertMaterial(mat)


    # The shaders to clone
    shader_bitmap_albedo = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_albedo.SetName("Albedo")
    shader_bitmap_albedo[c4d.BITMAPSHADER_FILENAME] = data["Albedo"]["path"]

    shader_bitmap_metalness =  c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_metalness[c4d.BITMAPSHADER_FILENAME] = data["Metalness"]["path"]
    shader_bitmap_metalness.SetName("Metalness")

    shader_bitmap_roughness =  c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_roughness.SetName("Roughness")
    shader_bitmap_roughness[c4d.BITMAPSHADER_FILENAME] = data["Roughness"]["path"]

    shader_bitmap_ao = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_ao.SetName("AO")
    shader_bitmap_ao[c4d.BITMAPSHADER_FILENAME] = data["AO"]["path"]

    shader_bitmap_trans = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_trans.SetName("Transparency")
    shader_bitmap_trans[c4d.BITMAPSHADER_FILENAME] = data["Transparency"]["path"]

    shader_bitmap_illum = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_illum.SetName("Emission")
    shader_bitmap_illum[c4d.BITMAPSHADER_FILENAME] = data["Emission"]["path"]

    shader_bitmap_bump = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_bump.SetName("Bump")
    shader_bitmap_bump[c4d.BITMAPSHADER_FILENAME] = data["Bump"]["path"]

    shader_bitmap_normal = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_normal.SetName("Normal")
    shader_bitmap_normal[c4d.BITMAPSHADER_FILENAME] = data["Normal"]["path"]

    shader_bitmap_displ = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_displ.SetName("Displacement")
    shader_bitmap_displ[c4d.BITMAPSHADER_FILENAME] = data["Displacement"]["path"]

    shader_bitmap_alpha = c4d.BaseShader(c4d.Xbitmap)
    shader_bitmap_alpha.SetName("Alpha")
    shader_bitmap_alpha[c4d.BITMAPSHADER_FILENAME] = data["Alpha"]["path"]

    # ======================================== Color Channel ===========================================================

    if data["Albedo"]["on"]:
        layer_shader = mat[c4d.MATERIAL_COLOR_SHADER]
        albedo = layer_shader.GetFirstLayer()
        albedo.GetParameter(c4d.LAYER_S_PARAM_SHADER_LINK)[c4d.BITMAPSHADER_FILENAME] = data["Albedo"]["path"]
        #albedo[c4d.BITMAPSHADER_FILENAME] = data["Albedo"]["path"]
        #print(albedo.GetName(doc))
        mask = albedo.GetNext()
        mask.GetParameter(c4d.LAYER_S_PARAM_SHADER_LINK)[c4d.BITMAPSHADER_FILENAME] = data["Metalness"]["path"]
        if not data["Metalness"]["on"]:
            mask.GetParameter(c4d.LAYER_S_PARAM_SHADER_LINK)[c4d.ID_BASELIST_NAME] = "No Metalness Map"
            mask.SetParameter(c4d.LAYER_S_PARAM_ALL_ACTIVE, False)

    if data["physical"]:
        mat[c4d.MATERIAL_USE_COLOR] = False


    #mask[c4d.BITMAPSHADER_FILENAME] = data["Metalness"]["path"]
    #print(mask.GetName(doc))

    # ======================================= Reflection Channel =======================================================

    # validate if physical Mode : then add an diffuse channel Reflectionchannel
    if data["Metalness"]["on"]:
        index_non_metal = 0
        if not data["physical"]:

            # ========================================Non Metal layer ==========================================================
            refl_layer_index = mat.GetReflectionLayerIndex(0)
            refl_layer_index.SetName("Non_Metal")
            refl_layer = refl_layer_index.GetDataID()
            mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_VALUE_BUMP] = 1

            # non metal layer slot ids
            rough_id = refl_layer + c4d.REFLECTION_LAYER_MAIN_SHADER_ROUGHNESS

            # non metal shader einstellungen
            if data["Roughness"]["on"]:
                shader_roughness = shader_bitmap_roughness.GetClone()
                mat[rough_id] = shader_roughness
                mat.InsertShader(shader_roughness)
                mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_VALUE_ROUGHNESS] = 1
                mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_VALUE_REFLECTION] = 1
                mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_DISTRIBUTION] = c4d.REFLECTION_DISTRIBUTION_BECKMANN
                mat[refl_layer + c4d.REFLECTION_LAYER_FRESNEL_MODE] = c4d.REFLECTION_FRESNEL_DIELECTRIC
            # =========================================== Non Metal End ========================================================

        else:
            diffuse_layer = mat.GetReflectionLayerIndex(0)
            diffuse_layer.SetName("Diffuse")
            diffuse_id = diffuse_layer.GetDataID()

            # non metal layer slot ids

            shader_color = shader_bitmap_albedo.GetClone()
            mat[diffuse_id + c4d.REFLECTION_LAYER_COLOR_TEXTURE] = shader_color
            mat.InsertShader(shader_color)
            mat[diffuse_id + c4d.REFLECTION_LAYER_MAIN_DISTRIBUTION] = c4d.REFLECTION_DISTRIBUTION_LAMBERTIAN
            mat[diffuse_id + c4d.REFLECTION_LAYER_MAIN_VALUE_REFLECTION] = 1
            # mat[diffuse_id + c4d.REFLECTION_LAYER_FRESNEL_MODE] = c4d.REFLECTION_FRESNEL_DIELECTRIC
            mat[diffuse_id + c4d.REFLECTION_LAYER_FRESNEL_MODE] = 0
            mat[diffuse_id + c4d.REFLECTION_LAYER_MAIN_VALUE_SPECULAR] = 1
            mat[diffuse_id + c4d.REFLECTION_LAYER_MAIN_VALUE_BUMP] = 0


            # adding non reflection layer
            refl_layer_index = mat.AddReflectionLayer()
            refl_layer_index.SetName("Non_Metal")
            refl_layer = refl_layer_index.GetDataID()
            mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_VALUE_BUMP] = 1
            

            # non metal layer slot ids
            rough_id = refl_layer + c4d.REFLECTION_LAYER_MAIN_SHADER_ROUGHNESS

            # non metal shader einstellungen
            if data["Roughness"]["on"]:
                shader_roughness = shader_bitmap_roughness.GetClone()
                mat[rough_id] = shader_roughness
                mat.InsertShader(shader_roughness)
                mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_VALUE_ROUGHNESS] = 1
                mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_VALUE_REFLECTION] = 1
                mat[refl_layer + c4d.REFLECTION_LAYER_MAIN_DISTRIBUTION] = c4d.REFLECTION_DISTRIBUTION_BECKMANN
                mat[refl_layer + c4d.REFLECTION_LAYER_FRESNEL_MODE] = c4d.REFLECTION_FRESNEL_DIELECTRIC
            # ============================================metal layer ==========================================================


        refl_layer_metallness_index = mat.AddReflectionLayer()
        refl_layer_metallness = refl_layer_metallness_index.GetDataID()
        refl_layer_metallness_index.SetName("Metallic")

        # metal layers slot id's
        metal_spec_id = refl_layer_metallness + c4d.REFLECTION_LAYER_COLOR_TEXTURE
        metal_rough_id = refl_layer_metallness + c4d.REFLECTION_LAYER_MAIN_SHADER_ROUGHNESS
        metal_mask_id = refl_layer_metallness + c4d.REFLECTION_LAYER_TRANS_TEXTURE

        # metal ebene einstellungen - albedo in spec, roughness und metalless in den Maskenkanal
        # Roughness
        shader_roughness_metal = shader_bitmap_roughness.GetClone()
        mat[metal_rough_id] = shader_roughness_metal
        mat.InsertShader(shader_roughness_metal)
        mat[refl_layer_metallness + c4d.REFLECTION_LAYER_MAIN_VALUE_ROUGHNESS] = 1
        mat[refl_layer_metallness + c4d.REFLECTION_LAYER_MAIN_DISTRIBUTION] = c4d.REFLECTION_DISTRIBUTION_BECKMANN
        mat[refl_layer_metallness + c4d.REFLECTION_LAYER_MAIN_VALUE_BUMP] = 1

        # Metal - Albedo into color channel in reflection layer
        shader_metallness_spec = shader_bitmap_albedo.GetClone()
        mat[metal_spec_id] = shader_metallness_spec
        mat.InsertShader(shader_metallness_spec)

        # Metal - Metalness Map in den Maskenkanal
        shader_metallness_mask = shader_bitmap_metalness.GetClone()
        mat[metal_mask_id] = shader_metallness_mask
        mat.InsertShader(shader_metallness_mask)
# ============================================Metal End ============================================================


    # =========================================== AO Settings ==========================================================
    if data["AO"]["on"]:
        mat[c4d.MATERIAL_USE_DIFFUSION] = True
        ao_shader = shader_bitmap_ao.GetClone()
        mat[c4d.MATERIAL_DIFFUSION_SHADER] = ao_shader
        mat.InsertShader(ao_shader)

        if not data["AO"]["path"]:
            mat[c4d.MATERIAL_USE_DIFFUSION] = False
    else:
        mat[c4d.MATERIAL_USE_DIFFUSION] = False
    # =========================================== AO Settings ==========================================================


    # ========================================== Emission Settings =====================================================
    if data["Emission"]["on"]:
        mat[c4d.MATERIAL_USE_LUMINANCE] = True
        illum_shader = shader_bitmap_illum.GetClone()
        mat[c4d.MATERIAL_LUMINANCE_SHADER] = illum_shader
        mat.InsertShader(illum_shader)

        if not data["AO"]["path"]:
            mat[c4d.MATERIAL_USE_LUMINANCE] = False
    else:
        mat[c4d.MATERIAL_USE_LUMINANCE] = False
    # =========================================  Emission Settings =====================================================

    # ========================================== Transparency Settings =================================================
    if data["Transparency"]["on"]:
        mat[c4d.MATERIAL_USE_TRANSPARENCY] = True
        trans_shader = shader_bitmap_trans.GetClone()
        mat[c4d.MATERIAL_TRANSPARENCY_SHADER]= trans_shader
        mat.InsertShader(trans_shader)
        transp_layer = mat.GetReflectionLayerTrans()
        #print(transp_layer.GetDataID())
        transp_layer_id = transp_layer.GetDataID()
        transp_rough_shader = shader_bitmap_roughness.GetClone()
        mat[transp_layer_id + c4d.REFLECTION_LAYER_MAIN_SHADER_ROUGHNESS] = transp_rough_shader
        mat.InsertShader(transp_rough_shader)
        mat[transp_layer_id + c4d.REFLECTION_LAYER_MAIN_VALUE_ROUGHNESS] = 1
        # mat[transp_layer_id + c4d.REFLECTION_LAYER_MAIN_SHADER_ROUGHNESS] = shader_roughness.GetClone()
        # mat[transp_layer_id + c4d.REFLECTION_LAYER_MAIN_VALUE_ROUGHNESS] = 1

        if not data["Transparency"]["path"]:
            mat[c4d.MATERIAL_USE_TRANSPARENCY] = False
    else:
        mat[c4d.MATERIAL_USE_TRANSPARENCY] = False
    # =========================================  Transparency Settings =================================================

    # ========================================== Bump Settings =========================================================
    if data["Bump"]["on"]:
        bump_shader = shader_bitmap_bump.GetClone()
        mat[c4d.MATERIAL_USE_BUMP] = True
        mat[c4d.MATERIAL_BUMP_SHADER] = bump_shader
        mat.InsertShader(bump_shader)
        if not data["Bump"]["path"]:
            mat[c4d.MATERIAL_USE_BUMP] = False

    else:
        mat[c4d.MATERIAL_USE_BUMP] = False
    # =========================================  Bump Settings =========================================================

    # ========================================== Normal Settings =======================================================
    if not data["bump2normal"]:
        if data["Normal"]["on"]:

            mat[c4d.MATERIAL_USE_NORMAL] = True
            normal_shader = shader_bitmap_normal.GetClone()
            mat[c4d.MATERIAL_NORMAL_SHADER] = normal_shader
            mat.InsertShader(normal_shader)

            if not data["Normal"]["path"]:
                mat[c4d.MATERIAL_USE_NORMAL] = False
        else:
            mat[c4d.MATERIAL_USE_NORMAL] = False
    else:
        if data["Bump"]["on"]:
            bump_shader = shader_bitmap_bump.GetClone()
       
            mat[c4d.MATERIAL_USE_NORMAL] = True
            normalize_shader = c4d.BaseShader(c4d.Xnormalizer)
            normalize_shader[c4d.XNORM_STRENGTH] = 1
            normalize_shader[c4d.XNORM_SHADERLINK] = bump_shader
            mat[c4d.MATERIAL_NORMAL_SHADER] = normalize_shader
            mat.InsertShader(normalize_shader)
            mat.InsertShader(bump_shader)
            #if not data["Normal"]["path"]:
            mat[c4d.MATERIAL_USE_NORMAL] = True
    # =========================================  Normal Settings =======================================================


    # ========================================== Alpha Settings ========================================================
    if data["Alpha"]["on"]:
        mat[c4d.MATERIAL_USE_ALPHA] = True
        alpha_shader = shader_bitmap_alpha.GetClone()
        mat[c4d.MATERIAL_NORMAL_SHADER] = alpha_shader
        mat.InsertShader(alpha_shader)

        if not data["Alpha"]["path"]:
            mat[c4d.MATERIAL_USE_ALPHA] = False
    else:
        mat[c4d.MATERIAL_USE_ALPHA] = False
    # =========================================  Alpha Settings ========================================================

    # ========================================== Displacement Settings =================================================
    if data["Displacement"]["on"]:
        mat[c4d.MATERIAL_USE_DISPLACEMENT] = True
        displace_shader = shader_bitmap_displ.GetClone()
        mat[c4d.MATERIAL_DISPLACEMENT_SHADER] = displace_shader
        mat.InsertShader(displace_shader)

        if not data["Displacement"]["path"]:
            mat[c4d.MATERIAL_USE_DISPLACEMENT] = False
    else:
        mat[c4d.MATERIAL_USE_DISPLACEMENT] = False
    # =========================================  Alpha Settings ========================================================

    #doc.InsertMaterial(mat)
    c4d.EventAdd()



# Execute main()
if __name__=='__main__':
    main()